package com.ptteng.yi.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.yi.etl.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.AppointOrder;
import com.ptteng.yi.nucleus.service.AppointOrderService;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import java.io.IOException;
import java.util.*;

public class AppointOrderEtl {

    private static final Log log = LogFactory.getLog(AppointOrderEtl.class);
    /**
     * @Fields:空转任务间隔休息毫秒数
     */
    private static final long SLEEP_MILLISECOND = 60000;

    private Long interval = 2000L;

    private AppointOrderService appointOrderService;

    public AppointOrderEtl() {
        super();
    }

    public void process() throws InterruptedException {
        while (true) {
            try {
                Long currentTime = System.currentTimeMillis();
                log.info("interval is  " + interval);
                Long zero = currentTime / (1000 * 3600 * 24) * (1000 * 3600 * 24)
                        - TimeZone.getDefault().getRawOffset();
                Long t = currentTime - zero;
                changeAppointOrder(zero, t);
                Thread.sleep(interval);
            } catch (Throwable t) {
                t.printStackTrace();
                Thread.sleep(interval);
                log.error("process check expire-user error ,sleep " + t.getMessage());
            }
        }
    }

    public void changeAppointOrder(Long zero, Long time) throws InterruptedException {
        try {
            log.info(time + "   tinm");
            log.info(zero + "   ze");
            Map<String, Object> conditions = new HashMap<>();
            conditions = DynamicUtil.getOrdersList(zero, time);
            log.info(conditions);
            List<Long> ids = this.appointOrderService.getIdsByDynamicCondition(AppointOrder.class, conditions, 0,
                    Integer.MAX_VALUE);
            List<AppointOrder> appointOrderList = this.appointOrderService.getObjectsByIds(ids);
            for (AppointOrder appointOrder : appointOrderList) {
                appointOrder.setType(5);
            }
            this.appointOrderService.updateList(appointOrderList);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
        }

    }

    public AppointOrderService getAppointOrderService() {
        return appointOrderService;
    }

    public void setAppointOrderService(AppointOrderService appointOrderService) {
        this.appointOrderService = appointOrderService;
    }

    public Long getInterval() {
        return interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

}
